unit fTemplateDialog;

{
   Package: TIU - TEXT INTEGRATION UTILITIES
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run.
         Includes Template routines from CPRS
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, IdGlobal,
  StdCtrls, ExtCtrls, ORCtrls, ORFn, VA508AccessibilityManager; //, AppEvnts;

type
  TfrmTemplateDialog = class(TForm)
    sbMain: TScrollBox;
    pnlBottom: TPanel;
    btnCancel: TButton;
    btnOK: TButton;
    btnAll: TButton;
    btnNone: TButton;
    btnPreview: TButton;
    va508Mgr: TVA508AccessibilityManager;
    lblFootnote: TStaticText;
    procedure btnAllClick(Sender: TObject);
    procedure btnNoneClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnOKClick(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
  private
    SL: TStrings;
    BuildIdx: TStringList;
    Entries: TStringList;
    NoTextID: TStringList;
      Index: string;
    OneOnly: boolean;
    Count: integer;
    RepaintBuild: boolean;
    Checking: boolean;
    FirstIndent: integer;
    FBuilding: boolean;
    FOldHintEvent: TShowHintEvent;
    FMaxPnlWidth: integer;
    FTabPos: integer;
    FCheck4Required: boolean;
    procedure ChkAll(Chk: boolean);
    procedure BuildCB(CBidx: integer; var Y: integer; FirstTime: boolean);
    procedure ItemChecked(Sender: TObject);
    procedure BuildAllControls;
    procedure AppShowHint(var HintStr: string; var CanShow: Boolean;
      var HintInfo: Controls.THintInfo);
    procedure FieldChanged(Sender: TObject);
    procedure EntryDestroyed(Sender: TObject);

  public
    { Public declarations }
  end;

// Returns True if Cancel button is pressed
function DoTemplateDialog(SL: TStrings; const CaptionText: string; PreviewMode: boolean = FALSE): boolean;
procedure CheckBoilerplate4Fields(SL: TStrings; const CaptionText: string = ''; PreviewMode: boolean = FALSE); overload;
procedure CheckBoilerplate4Fields(var AText: string; const CaptionText: string = ''; PreviewMode: boolean = FALSE); overload;

implementation

uses uConst, uTemplateFields, fRptBox, uHelp508Class, VA508AccessibilityRouter;
//uses uConst, uTemplateFields, fRptBox;
//,
//dShared,

{$R *.DFM}

const
  Gap = 4;
  IndentGap = 18;

var
  frmTemplateDialog: TfrmTemplateDialog;


  (***************************************************************************)
  (*********************     BRIANS SORT    5/22/2009  ***********************)
  (**  BEGIN  ****************************************************************)


const
  SLOP_FACTOR = 5;

function ComparePosition(Item1, Item2: Pointer): Integer;
var
  Control1,
    Control2: TControl;
  XDelta,
    YDelta: Integer;
begin
  result := 0; //Note: This result should never be used in practice (all the
               //code paths below should assign a different value to a result).
               //Unfortunately, the compiler isn't always smart enough to see that.
  try

    Control1 := TObject(Item1) as TControl;
    Control2 := TObject(Item2) as TControl;

    {
    Now that we have the controls, we have to compare them to decide where they go.
    We've defined a SLOP_FACTOR constant above to allow for sloppy placement of the
    control.  I expect that in MED, the controls are all placed to the pixel
    programmatically.  This is just for demonstration purposes.
    }

    YDelta := Control1.Left - Control2.Left;
    if Abs(YDelta) <= SLOP_FACTOR then
      YDelta := 0;

    if YDelta <> 0 then
    begin
      result := YDelta;
      exit; //No need to keep going.
    end;

    {
    If we get this far, the controls are in the same column.  Now, are they in the same
    row?

    Also note: We're only comparing based on Y then X coordinates.  So, if we get to the point
    that the two controls are within SLOP_FACTOR of each other in both X and Y coordinates,
    we're just going to return 0 and let the tab order stay the same between them.

    }

    XDelta := Control1.Top - Control2.Top;
    if Abs(XDelta) < SLOP_FACTOR then
      XDelta := 0;

    result := XDelta;
  except on E: EInvalidCast do
    { TODO -oHerb -c508 : Replace MessageDlg with MessageBox per Brian -- could not get handle to work }
//    MessageDlg('One of the items being sorted was not a control!', mtError, [mbOK], 0);
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      MessageBox(0, PChar('One of the items being sorted was not a control!'), '', MB_ICONERROR or MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
      MessageBox( frmTemplateDialog.Handle, PChar('One of the items being sorted was not a control!'), '', MB_ICONERROR or MB_OK);
        { TODO -omorriss -c3/1/2010 Make MessageBox Modal : Tried to change to self but self not visible here. }
//      MessageBox( self.Handle, PChar('One of the items being sorted was not a control!'), '', MB_ICONERROR or MB_OK);
  end;
end;

procedure CorrectTabOrder(AControl: TWinControl);
var
  ControlList: TList;
  I: Integer;
begin
  {
  Note: Each Control has a Controls[] array for all its children.
  So, the concept here is to sort all the controls at this level, and then tell each
  control to sort its child controls (if it has any).

  Recursion is a good thing here.

  Note also: Delphi isn't Java - while Delphi has MANY lingustic failings, one of
  the nice things about is that it doesn't require that you beat yourself to death
  trying to hammer everything into some sort of object paradigm.  It will work
  quite happily using bare (C-style) functions and procedures.
  }

  ControlList := TList.Create;
  try
    try
              {
              First, we get everything in the list.
              }
      for I := 0 to AControl.ControlCount - 1 do
        ControlList.Add(AControl.Controls[I]);

              {
              Now we sort.
              }
      ControlList.Sort(ComparePosition);

              {
              Now that our controls are sorted, we can go back through, assign tab order,
              and fix the tab order of any sub-controls on any control that has them.
              }
      for I := 0 to ControlList.Count - 1 do
      begin
        TWinControl(ControlList[I]).TabOrder := I;
        CorrectTabOrder(TWinControl(ControlList[I])); // RECURSIVE CALL
      end;

              {
              We're done!
              }
    except on E: Exception do
        { TODO -oherb -c508 : TODO -oHerb -c508 : Replace ShowMessage with MessageBox - Matt Greener said JAWS could not read the text }
//        ShowMessage('Exception occured in CorrectTabOrder' + E.Message);
        { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//        MessageBox(0, PChar('Exception occured in CorrectTabOrder' + E.Message), 'Error', MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
        MessageBox( frmTemplateDialog.Handle, PChar('Exception occured in CorrectTabOrder' + E.Message), 'Error', MB_OK);
{ TODO -oherb -c3/1/2010 Make MessageBox Modal : Tried to change to self but self not visible here. }
//        MessageBox( self.Handle, PChar('Exception occured in CorrectTabOrder' + E.Message), 'Error', MB_OK);
    end;
  finally
    {
    Note: since we're just pointing at TWinControls in our TList, we don't have
    to worry about freeing them.  The form (being the controls' ultimate parent),
    will take care of that when it itself is freed.
    }
    FreeAndNil(ControlList);
  end;

end;

  (**  END    ****************************************************************)
  (*********************     BRIANS SORT    5/22/2009  ***********************)
  (***************************************************************************)

procedure GetText(SL: TStrings);
var
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//  i, p1, p2: integer;
  i : integer;
  p1, p2: INT64;
  Txt, tmp: string;
  Save, Hidden: boolean;
  TmpCtrl: TStringList;

begin
  Txt := SL.Text;
  SL.Clear;
  TmpCtrl := TStringList.Create;
  try
    for i := 0 to frmTemplateDialog.sbMain.ControlCount - 1 do
      with frmTemplateDialog.sbMain do
      begin
        tmp := IntToStr(Controls[i].Tag);
        tmp := StringOfChar('0', 7 - length(tmp)) + tmp;
        TmpCtrl.AddObject(tmp, Controls[i]);
      end;
    TmpCtrl.Sort;




    for i := 0 to TmpCtrl.Count - 1 do
    begin
      Save := FALSE;
      if (TmpCtrl.Objects[i] is TORCheckBox) and (TORCheckBox(TmpCtrl.Objects[i]).Checked) then
        Save := TRUE
      else
        if (frmTemplateDialog.OneOnly and (TmpCtrl.Objects[i] is TPanel)) then
          Save := TRUE;
      if (Save) then
      begin
        tmp := Piece(frmTemplateDialog.Index, U, TControl(TmpCtrl.Objects[i]).Tag);
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//        p1 := StrToInt(Piece(tmp, '~', 1));
        p1 := StrToInt64(Piece(tmp, '~', 1));
//        p2 := StrToInt(Piece(tmp, '~', 2));
        p2 := StrToInt64(Piece(tmp, '~', 2));
        Hidden := (copy(Piece(tmp, '~', 3), 2, 1) = BOOLCHAR[TRUE]);
        SL.Text := SL.Text + ResolveTemplateFields(Copy(Txt, p1, p2), FALSE, Hidden);
      end;
    end;
  finally
    TmpCtrl.Free;
  end;
end;

// Returns True if Cancel button is pressed

function DoTemplateDialog(SL: TStrings; const CaptionText: string; PreviewMode: boolean = FALSE): boolean;
var
  i, j, idx, Indent: integer;
  DlgProps, Txt: string;


begin
  Result := FALSE;
  frmTemplateDialog := TfrmTemplateDialog.Create(Application);
  try
    if PreviewMode then
    begin
//      frmTemplateDialog.btnOK.Visible := FALSE;
      frmTemplateDialog.Height := 240;
    end;
    frmTemplateDialog.Caption := CaptionText;
    AssignFieldIDs(SL);
    frmTemplateDialog.SL := SL;
    frmTemplateDialog.Index := '';
    Txt := SL.Text;
    frmTemplateDialog.OneOnly := (DelimCount(Txt, ObjMarker) = 1);
    frmTemplateDialog.Count := 0;
    idx := 1;
    frmTemplateDialog.FirstIndent := 99999;
    repeat
      i := pos(ObjMarker, Txt);
      if (i > 1) then
      begin
        j := pos(DlgPropMarker, Txt);
        if (j > 0) then
          DlgProps := copy(Txt, j + DlgPropMarkerLen, (i - j - DlgPropMarkerLen))
        else
        begin
          DlgProps := '';
          j := i;
        end;
        inc(frmTemplateDialog.Count);
        frmTemplateDialog.Index := frmTemplateDialog.Index +
          IntToStr(idx) + '~' + IntToStr(j - 1) + '~' + DlgProps + U;
        inc(idx, i + ObjMarkerLen - 1);
        Indent := StrToIntDef(Piece(DlgProps, ';', 5), 0);
        if (frmTemplateDialog.FirstIndent > Indent) then
          frmTemplateDialog.FirstIndent := Indent;
      end;
      if (i > 0) then
        delete(txt, 1, i + ObjMarkerLen - 1);
    until (i = 0);
    if (frmTemplateDialog.Count > 0) then
    begin
      if (frmTemplateDialog.OneOnly) then
      begin
        frmTemplateDialog.btnNone.Visible := FALSE;
        frmTemplateDialog.btnAll.Visible := FALSE;
      end;
      frmTemplateDialog.BuildAllControls;


      { TODO -oherb -c508 mod : OK, this is where the control is given focus. }


      { TODO -oHerb -c508 : Adding in Brian's CorrectTabOrder }
//      CorrectTabOrder( frmTemplateDialog );   // CALL TO BRIAN'S CODE
{$IFDEF DEBUGB}
{ TODO -oherb -c508 : TODO -oHerb -c508 : Replace ShowMessage with MessageBox - Matt Greener said JAWS could not read the text }
//      ShowMessage('Sorting using CorrectTabOrder');
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      MessageBox(0, PChar('Sorting using CorrectTabOrder'), 'Message', MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      MessageBox( frmTemplateDialog.Handle, PChar('Sorting using CorrectTabOrder'), 'Message', MB_OK);
      MessageBox( self.Handle, PChar('Sorting using CorrectTabOrder'), 'Message', MB_OK);
      CorrectTabOrder(frmTemplateDialog); // CALL TO BRIAN'S CODE
{$ENDIF}

      frmTemplateDialog.ShowModal;
      if (frmTemplateDialog.ModalResult = mrOK) then
        GetText(SL)
      else
      begin
        SL.Clear;
        Result := TRUE;
      end;
    end
    else
      SL.Clear;
  finally
    frmTemplateDialog.Free;
  end;
  if not Result then
    CheckBoilerplate4Fields(SL);
end;

procedure CheckBoilerplate4Fields(SL: TStrings; const CaptionText: string = ''; PreviewMode: boolean = FALSE);
begin
  while (HasTemplateField(SL.Text)) do
  begin
    if (BoilerplateTemplateFieldsOK(SL.Text)) then
    begin
      SL[SL.Count - 1] := SL[SL.Count - 1] + DlgPropMarker + '00100;0;-1;;0' + ObjMarker;
      DoTemplateDialog(SL, CaptionText, PreviewMode);
    end
    else
      SL.Clear;
  end;
end;

procedure CheckBoilerplate4Fields(var AText: string; const CaptionText: string = ''; PreviewMode: boolean = FALSE);
var
  tmp: TStringList;

begin
  tmp := TStringList.Create;
  try
    tmp.text := AText;
    CheckBoilerplate4Fields(tmp, CaptionText, PreviewMode);
    AText := tmp.text;
  finally
    tmp.free;
  end;
end;

procedure TfrmTemplateDialog.ChkAll(Chk: boolean);
var
  i: integer;
begin
  for i := 0 to sbMain.ControlCount - 1 do
  begin
    if (sbMain.Controls[i] is TORCheckBox) then
      TORCheckBox(sbMain.Controls[i]).Checked := Chk;
  end;
end;

procedure TfrmTemplateDialog.btnAllClick(Sender: TObject);
begin
  ChkAll(TRUE);
end;

procedure TfrmTemplateDialog.btnNoneClick(Sender: TObject);
begin
  ChkAll(FALSE);
end;

procedure TfrmTemplateDialog.BuildCB(CBidx: integer; var Y: integer; FirstTime: boolean);
var
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//  bGap, Indent, i, idx, idx2, p1, p2: integer;
  bGap, Indent, i, idx, idx2 : integer;
  p1, p2: INT64;
  EID, ID, PID, DlgProps, tmp, txt, ObjID: string;
  pctrl, ctrl: TControl;
  pnl: TPanel;
  KillCtrl, doHint, dsp, noTextParent: boolean;
  Entry: TTemplateDialogEntry;

  procedure NextTabCtrl(ACtrl: TControl);
  begin
    if (ACtrl is TWinControl) then
    begin
      inc(FTabPos);
      TWinControl(ACtrl).TabOrder := FTabPos;
    end;
  end;

begin
  tmp := Piece(Index, U, CBidx);
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//  p1 := StrToInt(Piece(tmp, '~', 1));
//  p2 := StrToInt(Piece(tmp, '~', 2));
  p1 := StrToInt64(Piece(tmp, '~', 1));
  p2 := StrToInt64(Piece(tmp, '~', 2));
  DlgProps := Piece(tmp, '~', 3);
  ID := Piece(DlgProps, ';', 3);
  PID := Piece(DlgProps, ';', 4);

  ctrl := nil;
  pctrl := nil;
  if (PID <> '') then
    noTextParent := (NoTextID.IndexOf(PID) < 0)
  else
    noTextParent := TRUE;
  for i := 0 to sbMain.ControlCount - 1 do
  begin
    idx := sbMain.Controls[i].Tag;
    if (idx > 0) then
    begin
      idx2 := BuildIdx.IndexOfObject(TObject(idx));

      if idx2 >= 0 then
        ObjID := BuildIdx[idx2]
      else
        ObjID := Piece(Piece(Piece(Index, U, idx), '~', 3), ';', 3);


      if ((not FirstTime) and (not assigned(ctrl))) then
      begin
        if (ObjID = ID) then
          ctrl := sbMain.Controls[i];
      end;
      if (noTextParent and (PID <> '') and (not assigned(pctrl))) then
      begin
        if (ObjID = PID) then
          pctrl := sbMain.Controls[i];
      end;
      if (assigned(ctrl) and ((not noTextParent) or assigned(pctrl) or (PID = ''))) then
        break;
    end;
  end;

  if (PID = '') then
    KillCtrl := FALSE
  else
  begin
    if (assigned(pctrl)) then
    begin
      if (not (pctrl is TORCheckBox)) or
        (copy(DlgProps, 3, 1) = BOOLCHAR[TRUE]) then // show if parent is unchecked
        KillCtrl := FALSE
      else
        KillCtrl := (not TORCheckBox(pctrl).Checked);
    end
    else
      KillCtrl := noTextParent;
  end;
  if KillCtrl then
  begin
    if (assigned(ctrl)) then
    begin
      if (ctrl is TORCheckBox) and (assigned(TORCheckBox(ctrl).Associate)) then
        TORCheckBox(ctrl).Associate.Hide;
      idx := BuildIdx.IndexOfObject(TObject(ctrl.Tag));

      if idx >= 0 then
        BuildIdx.delete(idx);
      ctrl.Free;
    end;
    exit;
  end;
  tmp := copy(SL.Text, p1, p2);
  if (copy(tmp, length(tmp) - 1, 2) = CRLF) then
    delete(tmp, length(tmp) - 1, 2);
  bGap := StrToIntDef(copy(DlgProps, 5, 1), 0);
  while bGap > 0 do
  begin
    if (copy(tmp, 1, 2) = CRLF) then
    begin
      delete(tmp, 1, 2);
      dec(bGap);
    end
    else
      bGap := 0;
  end;
  if (tmp = NoTextMarker) then
  begin
    if (NoTextID.IndexOf(ID) < 0) then
      NoTextID.Add(ID);
    exit;
  end;
  if (not assigned(ctrl)) then
  begin
    dsp := (copy(DlgProps, 1, 1) = BOOLCHAR[TRUE]);
    EID := 'DLG' + IntToStr(CBIdx);
    idx := Entries.IndexOf(EID);

    doHint := FALSE;
    txt := tmp;
    if (idx < 0) then
    begin
      if (copy(DlgProps, 2, 1) = BOOLCHAR[TRUE]) then // First Line Only
      begin
        i := pos(CRLF, tmp);
        if (i > 0) then
        begin
          dec(i);
          if i > 70 then
          begin
            i := 71;
            while (i > 0) and (tmp[i] <> ' ') do dec(i);
            if i = 0 then
              i := 70
            else
              dec(i);
          end;
          doHint := TRUE;
          tmp := copy(tmp, 1, i) + ' ...';
        end;
      end;
      Entry := GetDialogEntry(sbMain, EID, tmp);
      Entry.AutoDestroyOnPanelFree := TRUE;
      Entry.OnDestroy := EntryDestroyed;
      Entries.AddObject(EID, Entry);

    end
    else
      Entry := TTemplateDialogEntry(Entries.Objects[idx]);

    pnl := Entry.GetPanel(FMaxPnlWidth, sbMain);


    { TODO -oherb -c508 mod : Is this where I want to reset the tabs? }



    pnl.Show;

    if (doHint and (not pnl.ShowHint)) then
    begin
      pnl.ShowHint := TRUE;
      Entry.Obj := pnl;
      Entry.Text := txt;
      pnl.hint := Entry.GetText;
      Entry.OnChange := FieldChanged;
    end;
    if (dsp or OneOnly) then
      ctrl := pnl
    else
    begin
      ctrl := TORCheckBox.Create(Self);
      ctrl.Parent := sbMain;
      TORCheckBox(ctrl).Associate := pnl;
      ctrl.Width := 13;
    end;
    ctrl.Tag := CBIdx;

    Indent := StrToIntDef(Piece(DlgProps, ';', 5), 0) - FirstIndent;
    if dsp then inc(Indent);
    ctrl.Left := Gap + (Indent * IndentGap);
    //ctrl.Width := sbMain.ClientWidth - Gap - ctrl.Left - ScrollBarWidth;
    if (ctrl is TORCheckBox) then
      pnl.Left := ctrl.Left + IndentGap;

    if (ctrl is TORCheckBox) then with TORCheckBox(ctrl) do
      begin
        GroupIndex := StrToIntDef(Piece(DlgProps, ';', 2), 0);
        if (GroupIndex <> 0) then
          RadioStyle := TRUE;
        OnClick := ItemChecked;
        StringData := DlgProps;
      end;

    if BuildIdx.IndexOfObject(TObject(CBIdx)) < 0 then
      BuildIdx.AddObject(Piece(Piece(Piece(Index, U, CBIdx), '~', 3), ';', 3), TObject(CBIdx));

  end;
  ctrl.Top := Y;
  NextTabCtrl(ctrl);
  if (ctrl is TORCheckBox) then
  begin
    TORCheckBox(ctrl).Associate.Top := Y;
    NextTabCtrl(TORCheckBox(ctrl).Associate);
    inc(Y, TORCheckBox(ctrl).Associate.Height + 1);
  end
  else
    inc(Y, ctrl.Height + 1);
end;

procedure TfrmTemplateDialog.ItemChecked(Sender: TObject);
begin
  if (copy(TORCheckBox(Sender).StringData, 4, 1) = '1') then
  begin
    RepaintBuild := TRUE;
    Invalidate;
  end;
end;

procedure TfrmTemplateDialog.BuildAllControls;
var
  i, Y: integer;
  FirstTime: boolean;

begin
  if FBuilding then exit;
  FBuilding := TRUE;
  try
    FTabPos := 0;
    FirstTime := (sbMain.ControlCount = 0);
    NoTextID.Clear;
    Y := Gap - sbMain.VertScrollBar.Position;
    for i := 1 to Count do
      BuildCB(i, Y, FirstTime);
  finally
    FBuilding := FALSE;
  end;
end;

procedure TfrmTemplateDialog.FormPaint(Sender: TObject);
begin
  if RepaintBuild and Checking = False then
  begin
    RepaintBuild := FALSE;
    BuildAllControls;
  end;
end;

procedure TfrmTemplateDialog.FormCreate(Sender: TObject);
begin

  BuildIdx := TStringList.Create;
  Entries := TStringList.Create;
  NoTextID := TStringList.Create;
  FOldHintEvent := Application.OnShowHint;
  Application.OnShowHint := AppShowHint;
  FMaxPnlWidth := FontWidthPixel(sbMain.Font.Handle) * MAX_ENTRY_WIDTH;

  { TODO -oHerb -c508 : Adding Tabstop to TStaticText Controls }
   lblFootnote.TabStop := ScreenReaderSystemActive;

end;

procedure TfrmTemplateDialog.AppShowHint(var HintStr: string;
  var CanShow: Boolean; var HintInfo: Controls.THintInfo);
const
  HistHintDelay = 1200000; // 20 minutes

begin
//  if(HintInfo.HintControl.Parent = sbMain) then
  HintInfo.HideTimeout := HistHintDelay;
  if (assigned(FOldHintEvent)) then
    FOldHintEvent(HintStr, CanShow, HintInfo);
end;

procedure TfrmTemplateDialog.FormDestroy(Sender: TObject);
begin
  Application.OnShowHint := FOldHintEvent;
  NoTextID.Free;
  FreeEntries(Entries);
  Entries.Free;
  BuildIdx.Free;
end;

procedure TfrmTemplateDialog.FieldChanged(Sender: TObject);
begin
  with TTemplateDialogEntry(Sender) do
    TPanel(Obj).hint := GetText;
end;

procedure TfrmTemplateDialog.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  Txt, tmp: string;
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//  i, p1, p2: integer;
  i : integer;
  p1, p2: INT64;
  Save: boolean;

begin
  CanClose := TRUE;
  if FCheck4Required then
  begin
    FCheck4Required := FALSE;
    Txt := SL.Text;
    for i := 0 to sbMain.ControlCount - 1 do
    begin
      Save := FALSE;
      if (sbMain.Controls[i] is TORCheckBox) and
        (TORCheckBox(sbMain.Controls[i]).Checked) then
        Save := TRUE
      else
        if (OneOnly and (sbMain.Controls[i] is TPanel)) then
          Save := TRUE;
      if (Save) then
      begin
        tmp := Piece(Index, U, sbMain.Controls[i].Tag);
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//        p1 := StrToInt(Piece(tmp, '~', 1));
//        p2 := StrToInt(Piece(tmp, '~', 2));
        p1 := StrToInt64(Piece(tmp, '~', 1));
        p2 := StrToInt64(Piece(tmp, '~', 2));
        if AreTemplateFieldsRequired(Copy(Txt, p1, p2)) then
          CanClose := FALSE;
      end;
      if not CanClose then
      begin
      { TODO -oHerb -c508 : Replace ShowMessage with MessageBox - Matt Greener said JAWS could not read the text}
//    ShowMessage(MissingFieldsTxt);
      { TODO -oHerb -c2/27/2010 Make MessageBox Modal : Need to make MessageBox Modal to owner. }
//      MessageBox(0, PChar(MissingFieldsTxt), 'Warning Message', MB_OK);
{ TODO -omorriss -c3/1/2010 Make MessageBox Modal : Changing the actual frm reference to self to be fix issue with TfrmGetPat locking up }
//      MessageBox( frmTemplateDialog.Handle, PChar(MissingFieldsTxt), 'Warning Message', MB_OK);
      MessageBox( self.Handle, PChar(MissingFieldsTxt), 'Warning Message', MB_OK);
        break;
      end;
    end;
  end;
end;

procedure TfrmTemplateDialog.btnOKClick(Sender: TObject);
begin
  FCheck4Required := TRUE;
end;

procedure TfrmTemplateDialog.btnPreviewClick(Sender: TObject);
var
  TmpSL: TStringList;

begin
  TmpSL := TStringList.Create;
  try
    TmpSL.Assign(SL);
    GetText(TmpSL);
    ReportBox(TmpSL, 'Dialog Preview', FALSE);
  finally
    TmpSL.Free;
  end;
end;


procedure TfrmTemplateDialog.EntryDestroyed(Sender: TObject);
var
  idx: integer;

begin
  idx := Entries.IndexOf(TTemplateDialogEntry(Sender).ID);
  if idx >= 0 then
    Entries.delete(idx);
end;

end.
